/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jrobin.core.Archive;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Util {
    static final String PATTERN = "0.0000000000E00";
    static final String JROBIN_DIR = "jrobin-demo";
    static final DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(Locale.ENGLISH);
    private static final File homeDirFile;
    private static final String homeDirPath;
    static final String ISO_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static Date lastLap;

    public static long getTime() {
        return (System.currentTimeMillis() + 500L) / 1000L;
    }

    public static long getTimestamp() {
        return Util.getTime();
    }

    public static long normalize(long l, long l2) {
        return l - l % l2;
    }

    public static double max(double d, double d2) {
        return Double.isNaN(d) ? d2 : (Double.isNaN(d2) ? d : Math.max(d, d2));
    }

    public static double min(double d, double d2) {
        return Double.isNaN(d) ? d2 : (Double.isNaN(d2) ? d : Math.min(d, d2));
    }

    static double sum(double d, double d2) {
        return Double.isNaN(d) ? d2 : (Double.isNaN(d2) ? d : d + d2);
    }

    static String formatDouble(double d, String string, boolean bl) {
        if (Double.isNaN(d)) {
            return string;
        }
        if (bl) {
            return df.format(d);
        }
        return "" + d;
    }

    static String formatDouble(double d, boolean bl) {
        return Util.formatDouble(d, "NaN", bl);
    }

    public static Date getDate(long l) {
        return new Date(l * 1000L);
    }

    public static GregorianCalendar getGregorianCalendar(long l) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(l * 1000L);
        return gregorianCalendar;
    }

    public static GregorianCalendar getGregorianCalendar(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        return gregorianCalendar;
    }

    public static long getTimestamp(Date date) {
        return (date.getTime() + 499L) / 1000L;
    }

    public static long getTimestamp(GregorianCalendar gregorianCalendar) {
        return Util.getTimestamp(gregorianCalendar.getTime());
    }

    public static long getTimestamp(int n, int n2, int n3, int n4, int n5) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n, n2, n3, n4, n5);
        return Util.getTimestamp(gregorianCalendar);
    }

    public static long getTimestamp(int n, int n2, int n3) {
        return Util.getTimestamp(n, n2, n3, 0, 0);
    }

    public static double parseDouble(String string) {
        double d;
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = Double.NaN;
        }
        return d;
    }

    public static boolean parseBoolean(String string) {
        return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("on") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("y") || string.equalsIgnoreCase("1");
    }

    public static String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    public static String getUserHomeDirectory() {
        return System.getProperty("user.home") + Util.getFileSeparator();
    }

    public static String getJRobinDemoDirectory() {
        return homeDirFile.exists() || homeDirFile.mkdirs() ? homeDirPath : null;
    }

    public static String getJRobinDemoPath(String string) {
        String string2 = Util.getJRobinDemoDirectory();
        if (string2 != null) {
            return string2 + string;
        }
        return null;
    }

    static boolean sameFilePath(String string, String string2) throws IOException {
        File file = new File(string);
        File file2 = new File(string2);
        return file.getCanonicalPath().equals(file2.getCanonicalPath());
    }

    static int getMatchingDatasourceIndex(RrdDb rrdDb, int n, RrdDb rrdDb2) throws IOException {
        String string = rrdDb.getDatasource(n).getDsName();
        try {
            return rrdDb2.getDsIndex(string);
        }
        catch (RrdException rrdException) {
            return -1;
        }
    }

    static int getMatchingArchiveIndex(RrdDb rrdDb, int n, RrdDb rrdDb2) throws IOException {
        Archive archive = rrdDb.getArchive(n);
        String string = archive.getConsolFun();
        int n2 = archive.getSteps();
        try {
            return rrdDb2.getArcIndex(string, n2);
        }
        catch (RrdException rrdException) {
            return -1;
        }
    }

    static String getTmpFilename() throws IOException {
        return File.createTempFile("JROBIN_", ".tmp").getCanonicalPath();
    }

    public static GregorianCalendar getGregorianCalendar(String string) {
        try {
            long l = Long.parseLong(string);
            return Util.getGregorianCalendar(l);
        }
        catch (NumberFormatException numberFormatException) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ISO_DATE_FORMAT);
            simpleDateFormat.setLenient(false);
            try {
                Date date = simpleDateFormat.parse(string);
                return Util.getGregorianCalendar(date);
            }
            catch (ParseException parseException) {
                throw new IllegalArgumentException("Time/date not in yyyy-MM-dd HH:mm:ss format: " + string);
            }
        }
    }

    public static String getLapTime() {
        Date date = new Date();
        double d = (double)(date.getTime() - lastLap.getTime()) / 1000.0;
        lastLap = date;
        return "[" + d + " sec]";
    }

    public static String getJRobinHomeDirectory() {
        String string = Util.class.getName().replace('.', '/');
        String string2 = Util.class.getResource("/" + string + ".class").toString();
        if (string2.startsWith("file:/")) {
            string2 = string2.substring(6);
            File file = new File(string2);
            for (int i = 0; i < 5; ++i) {
                file = file.getParentFile();
            }
            string2 = file.getAbsolutePath();
        } else if (string2.startsWith("jar:file:/")) {
            string2 = string2.substring(10, string2.lastIndexOf(33));
            File file = new File(string2);
            for (int i = 0; i < 2; ++i) {
                file = file.getParentFile();
            }
            string2 = file.getAbsolutePath();
        } else {
            string2 = null;
        }
        return string2;
    }

    public static boolean equal(double d, double d2) {
        if (Double.isNaN(d) && Double.isNaN(d2)) {
            return true;
        }
        return d == d2;
    }

    static {
        df.applyPattern(PATTERN);
        df.setPositivePrefix("+");
        homeDirPath = Util.getUserHomeDirectory() + JROBIN_DIR + Util.getFileSeparator();
        homeDirFile = new File(homeDirPath);
        lastLap = new Date();
    }

    public static class Xml {
        public static Node[] getChildNodes(Node node) {
            return Xml.getChildNodes(node, null);
        }

        public static Node[] getChildNodes(Node node, String string) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (string != null && !node2.getNodeName().equals(string)) continue;
                arrayList.add(node2);
            }
            return arrayList.toArray(new Node[0]);
        }

        public static Node getFirstChildNode(Node node, String string) throws RrdException {
            Node[] nodeArray = Xml.getChildNodes(node, string);
            if (nodeArray.length > 0) {
                return nodeArray[0];
            }
            throw new RrdException("XML Error, no such child: " + string);
        }

        public static boolean hasChildNode(Node node, String string) {
            Node[] nodeArray = Xml.getChildNodes(node, string);
            return nodeArray.length > 0;
        }

        public static String getChildValue(Node node, String string) throws RrdException {
            return Xml.getChildValue(node, string, true);
        }

        public static String getChildValue(Node node, String string, boolean bl) throws RrdException {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (!node2.getNodeName().equals(string)) continue;
                return Xml.getValue(node2, bl);
            }
            throw new RrdException("XML Error, no such child: " + string);
        }

        public static String getValue(Node node) {
            return Xml.getValue(node, true);
        }

        public static String getValue(Node node, boolean bl) {
            String string = null;
            Node node2 = node.getFirstChild();
            if (node2 != null && (string = node2.getNodeValue()) != null && bl) {
                string = string.trim();
            }
            return string;
        }

        public static int getChildValueAsInt(Node node, String string) throws RrdException {
            String string2 = Xml.getChildValue(node, string);
            return Integer.parseInt(string2);
        }

        public static int getValueAsInt(Node node) {
            String string = Xml.getValue(node);
            return Integer.parseInt(string);
        }

        public static long getChildValueAsLong(Node node, String string) throws RrdException {
            String string2 = Xml.getChildValue(node, string);
            return Long.parseLong(string2);
        }

        public static long getValueAsLong(Node node) {
            String string = Xml.getValue(node);
            return Long.parseLong(string);
        }

        public static double getChildValueAsDouble(Node node, String string) throws RrdException {
            String string2 = Xml.getChildValue(node, string);
            return Util.parseDouble(string2);
        }

        public static double getValueAsDouble(Node node) {
            String string = Xml.getValue(node);
            return Util.parseDouble(string);
        }

        public static boolean getChildValueAsBoolean(Node node, String string) throws RrdException {
            String string2 = Xml.getChildValue(node, string);
            return Util.parseBoolean(string2);
        }

        public static boolean getValueAsBoolean(Node node) {
            String string = Xml.getValue(node);
            return Util.parseBoolean(string);
        }

        public static Element getRootElement(InputSource inputSource) throws RrdException, IOException {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            documentBuilderFactory.setNamespaceAware(false);
            try {
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(inputSource);
                return document.getDocumentElement();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new RrdException(parserConfigurationException);
            }
            catch (SAXException sAXException) {
                throw new RrdException(sAXException);
            }
        }

        public static Element getRootElement(String string) throws RrdException, IOException {
            return Xml.getRootElement(new InputSource(new StringReader(string)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Element getRootElement(File file) throws RrdException, IOException {
            FileReader fileReader = null;
            try {
                fileReader = new FileReader(file);
                Element element = Xml.getRootElement(new InputSource(fileReader));
                return element;
            }
            finally {
                if (fileReader != null) {
                    ((Reader)fileReader).close();
                }
            }
        }
    }
}

