/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.videolan.vlma.VLMaService;
import org.videolan.vlma.exception.NotFoundException;
import org.videolan.vlma.model.Media;
import org.videolan.vlma.model.Program;
import org.videolan.vlma.model.StreamingStrategy;

public class IpBank {
    private static final Logger logger = Logger.getLogger(IpBank.class);
    private HashMap<InetAddress, Boolean> usedIps;
    private VLMaService vlmaService;
    private Configuration configuration;

    public synchronized void initIps() throws UnknownHostException {
        Inet4Address min = (Inet4Address)InetAddress.getByName(this.configuration.getString("vlma.streaming.udp.ipbank.min"));
        Inet4Address max = (Inet4Address)InetAddress.getByName(this.configuration.getString("vlma.streaming.udp.ipbank.max"));
        this.usedIps = new HashMap();
        this.usedIps.clear();
        for (int ip = this.ipv42int(min); ip < this.ipv42int(max); ++ip) {
            this.usedIps.put(this.int2ipv4(ip), Boolean.FALSE);
        }
        for (Media m : this.vlmaService.getMedias()) {
            Program p = m.getProgram();
            if (p == null || !p.getStreamingStrategy().getProtocol().equals((Object)StreamingStrategy.Protocol.UDP_MULTICAST)) continue;
            logger.debug((Object)("The media " + m.getName() + " has a program"));
            if (!this.usedIps.containsKey(p.getIp())) continue;
            this.usedIps.put(p.getIp(), Boolean.TRUE);
        }
    }

    public synchronized boolean isUsed(InetAddress ip) {
        return this.usedIps.containsKey(ip) && this.usedIps.get(ip) != false;
    }

    public synchronized InetAddress getIp() {
        for (Map.Entry<InetAddress, Boolean> entry : this.usedIps.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            entry.setValue(Boolean.TRUE);
            return entry.getKey();
        }
        throw new NotFoundException("No free IP found in the IP bank");
    }

    public synchronized void releaseIp(InetAddress ip) {
        if (ip == null) {
            return;
        }
        if (this.usedIps.containsKey(ip)) {
            this.usedIps.put(ip, Boolean.FALSE);
        } else {
            logger.warn((Object)("IP address " + ip.getHostAddress() + " is not in the pool"));
        }
    }

    private int ipv42int(Inet4Address ip) {
        int result = 0;
        byte[] t = ip.getAddress();
        for (int i = 0; i < 4; ++i) {
            result += (t[i] & 0xFF) << 8 * (3 - i);
        }
        return result;
    }

    private Inet4Address int2ipv4(int ip) throws UnknownHostException {
        byte[] result = new byte[4];
        for (int i = 0; i < 4; ++i) {
            result[i] = (byte)(ip >> 8 * (3 - i) & 0xFF);
        }
        return (Inet4Address)Inet4Address.getByAddress(result);
    }

    public void setVlmaService(VLMaService vlmaService) {
        this.vlmaService = vlmaService;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

