/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.dao;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.videolan.vlma.dao.VLMaDao;
import org.videolan.vlma.exception.NotFoundException;
import org.videolan.vlma.model.Adapter;
import org.videolan.vlma.model.DTTChannel;
import org.videolan.vlma.model.DVBSAdapter;
import org.videolan.vlma.model.DVBTAdapter;
import org.videolan.vlma.model.FilesAdapter;
import org.videolan.vlma.model.FilesChannel;
import org.videolan.vlma.model.Media;
import org.videolan.vlma.model.Program;
import org.videolan.vlma.model.SatChannel;
import org.videolan.vlma.model.Satellite;
import org.videolan.vlma.model.Server;
import org.videolan.vlma.model.StreamAdapter;
import org.videolan.vlma.model.StreamChannel;
import org.videolan.vlma.model.StreamingStrategy;
import org.videolan.vlma.watcher.DirectMulticastStreamWatcher;
import org.videolan.vlma.watcher.HttpStreamWatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VLMaDaoImpl
implements VLMaDao {
    private static final Logger logger = Logger.getLogger(VLMaDaoImpl.class);
    public static final String DATA_FILE = "data.xml";
    private Configuration configuration;
    private Map<Integer, Media> medias = new HashMap<Integer, Media>();
    private Map<Integer, Satellite> satellites = new HashMap<Integer, Satellite>();
    private Map<Integer, Server> servers = new HashMap<Integer, Server>();
    private static final Random random = new Random();
    private static final XStream xstream = new XStream();

    @Override
    public void addAll(Collection<Media> medias) {
        for (Media media : medias) {
            this.addInternal(media);
        }
        this.saveToDisk();
    }

    @Override
    public void add(Media media) {
        this.addInternal(media);
        this.saveToDisk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInternal(Media media) {
        Map<Integer, Media> map = this.medias;
        synchronized (map) {
            Integer id;
            while (this.medias.containsKey(id = Integer.valueOf(random.nextInt()))) {
            }
            media.setId(id);
            this.medias.put(id, media);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Satellite satellite) {
        Map<Integer, Satellite> map = this.satellites;
        synchronized (map) {
            Integer id;
            while (this.satellites.containsKey(id = Integer.valueOf(random.nextInt()))) {
            }
            satellite.setId(id.intValue());
            this.satellites.put(id, satellite);
        }
        this.saveToDisk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Server server) {
        Map<Integer, Satellite> map = this.satellites;
        synchronized (map) {
            Integer id;
            while (this.satellites.containsKey(id = Integer.valueOf(random.nextInt()))) {
            }
            server.setId(id);
            this.servers.put(id, server);
        }
        this.saveToDisk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Media getMedia(int id) {
        Media result;
        Map<Integer, Media> map = this.medias;
        synchronized (map) {
            result = this.medias.get(id);
        }
        if (result != null) {
            return result;
        }
        throw new NotFoundException("The is no media with ID: " + id + " in the database");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Media> getMedias() {
        Map<Integer, Media> map = this.medias;
        synchronized (map) {
            ArrayList<Media> result = new ArrayList<Media>();
            result.addAll(this.medias.values());
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Satellite getSatellite(int id) {
        Satellite result;
        Map<Integer, Satellite> map = this.satellites;
        synchronized (map) {
            result = this.satellites.get(id);
        }
        if (result != null) {
            return result;
        }
        throw new NotFoundException("The is no satellite with ID: " + id + " in the database");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Satellite> getSatellites() {
        Map<Integer, Satellite> map = this.satellites;
        synchronized (map) {
            ArrayList<Satellite> result = new ArrayList<Satellite>();
            result.addAll(this.satellites.values());
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Server getServer(int id) {
        Server result;
        Map<Integer, Server> map = this.servers;
        synchronized (map) {
            result = this.servers.get(id);
        }
        if (result != null) {
            return result;
        }
        throw new NotFoundException("The is no server with ID: " + id + " in the database");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Server> getServers() {
        Map<Integer, Server> map = this.servers;
        synchronized (map) {
            ArrayList<Server> result = new ArrayList<Server>();
            result.addAll(this.servers.values());
            return result;
        }
    }

    @Override
    public void removeAll(Collection<Media> medias) {
        for (Media media : medias) {
            this.removeInternal(media);
        }
        this.saveToDisk();
    }

    @Override
    public void remove(Media media) {
        this.removeInternal(media);
        this.saveToDisk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInternal(Media media) {
        int id = media.getId();
        Map<Integer, Media> map = this.medias;
        synchronized (map) {
            if (!this.medias.containsKey(id)) {
                throw new NotFoundException("Media " + media.getName() + " is not in the database.");
            }
            this.medias.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Satellite satellite) {
        int id = satellite.getId();
        Map<Integer, Satellite> map = this.satellites;
        synchronized (map) {
            if (this.satellites.containsKey(id)) {
                this.satellites.remove(id);
                Map<Integer, Server> map2 = this.servers;
                synchronized (map2) {
                    for (Server server : this.servers.values()) {
                        Iterator adapterIt = server.getAdapters().iterator();
                        while (adapterIt.hasNext()) {
                            Adapter adapter = (Adapter)adapterIt.next();
                            if (!(adapter instanceof DVBSAdapter) || ((DVBSAdapter)adapter).getSatellite().getId() != id) continue;
                            adapterIt.remove();
                        }
                    }
                }
            } else {
                throw new NotFoundException("Satellite " + satellite.getName() + " is not in the database.");
            }
            this.saveToDisk();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Server server) {
        int id = server.getId();
        Map<Integer, Server> map = this.servers;
        synchronized (map) {
            if (this.servers.containsKey(id)) {
                this.servers.remove(id);
                Map<Integer, Media> map2 = this.medias;
                synchronized (map2) {
                    for (Media media : this.medias.values()) {
                        if (!(media instanceof FilesChannel) || ((FilesChannel)media).getServer().getId() != id) continue;
                        this.medias.remove(media.getId());
                    }
                }
            } else {
                throw new NotFoundException("Server " + server.getName() + " is not in the database.");
            }
            this.saveToDisk();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Media media) {
        int id = media.getId();
        Map<Integer, Media> map = this.medias;
        synchronized (map) {
            if (media instanceof FilesChannel && ((FilesChannel)media).getServer() != null) {
                ((FilesChannel)media).setServer(this.getServer(((FilesChannel)media).getServer().getId()));
            }
            if (!this.medias.containsKey(id)) {
                throw new NotFoundException("Media " + media.getName() + " is not in the database.");
            }
            this.medias.put(id, media);
            this.saveToDisk();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Satellite satellite) {
        int id = satellite.getId();
        Map<Integer, Satellite> map = this.satellites;
        synchronized (map) {
            if (!this.satellites.containsKey(id)) {
                throw new NotFoundException("Satellite " + satellite.getName() + " is not in the database.");
            }
            this.satellites.put(id, satellite);
            this.saveToDisk();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Server server) {
        int id = server.getId();
        Map<Integer, Server> map = this.servers;
        synchronized (map) {
            if (this.servers.containsKey(id)) {
                for (Adapter adapter : server.getAdapters()) {
                    if (!(adapter instanceof DVBSAdapter)) continue;
                    int satelliteId = ((DVBSAdapter)adapter).getSatellite().getId();
                    ((DVBSAdapter)adapter).setSatellite(this.getSatellite(satelliteId));
                }
            } else {
                throw new NotFoundException("Server " + server.getName() + " is not in the database.");
            }
            this.servers.put(id, server);
            this.saveToDisk();
        }
    }

    @Override
    public synchronized void saveToDisk() {
        long start = System.currentTimeMillis();
        DataContainer data = new DataContainer();
        data.satellites = this.getSatellites();
        data.servers = this.getServers();
        data.medias = this.getMedias();
        String vlmaData = this.configuration.getString("vlma.data");
        File dataFile = new File(vlmaData, DATA_FILE);
        try {
            FileOutputStream f = new FileOutputStream(dataFile);
            xstream.toXML((Object)data, (OutputStream)f);
            try {
                f.close();
                logger.debug((Object)("Data saved in " + (System.currentTimeMillis() - start) + "ms"));
            }
            catch (IOException e) {
                logger.error((Object)("Error while closing " + dataFile), (Throwable)e);
            }
        }
        catch (FileNotFoundException e) {
            logger.error((Object)("Can't save data to " + dataFile), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void loadFromDisk() {
        String vlmaData = this.configuration.getString("vlma.data");
        try {
            File dataFile = new File(vlmaData, DATA_FILE);
            FileInputStream f = new FileInputStream(dataFile);
            DataContainer data = (DataContainer)xstream.fromXML((InputStream)f);
            try {
                f.close();
            }
            catch (IOException e) {
                logger.error((Object)("Error closing " + dataFile), (Throwable)e);
            }
            Map<Integer, Satellite> map = this.satellites;
            synchronized (map) {
                this.satellites = new HashMap<Integer, Satellite>();
                for (Satellite satellite : data.satellites) {
                    this.satellites.put(satellite.getId(), satellite);
                }
            }
            map = this.servers;
            synchronized (map) {
                this.servers = new HashMap<Integer, Server>();
                for (Server server : data.servers) {
                    this.servers.put(server.getId(), server);
                }
            }
            map = this.medias;
            synchronized (map) {
                this.medias = new HashMap<Integer, Media>();
                for (Media media : data.medias) {
                    this.medias.put(media.getId(), media);
                }
            }
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)"Unable to read data.xml");
        }
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    static {
        xstream.alias("satellite", Satellite.class);
        xstream.alias("server", Server.class);
        xstream.alias("dvb-t", DVBTAdapter.class);
        xstream.alias("dvb-s", DVBSAdapter.class);
        xstream.alias("filesAdapter", FilesAdapter.class);
        xstream.alias("streamAdapter", StreamAdapter.class);
        xstream.alias("program", Program.class);
        xstream.alias("satChannel", SatChannel.class);
        xstream.alias("dttChannel", DTTChannel.class);
        xstream.alias("filesChannel", FilesChannel.class);
        xstream.alias("streamChannel", StreamChannel.class);
        xstream.alias("httpStreamWatcher", HttpStreamWatcher.class);
        xstream.alias("directMulticastStreamWatcher", DirectMulticastStreamWatcher.class);
        xstream.alias("streamingStrategy", StreamingStrategy.class);
        xstream.alias("announcement", StreamingStrategy.Announcement.class);
        xstream.alias("data", DataContainer.class);
        xstream.setMode(1004);
    }

    private static class DataContainer {
        public List<Satellite> satellites;
        public List<Server> servers;
        public List<Media> medias;

        private DataContainer() {
        }
    }
}

