/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.watcher;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.MulticastSocket;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.videolan.vlma.model.Program;
import org.videolan.vlma.watcher.StreamWatcher;

public class DirectMulticastStreamWatcher
implements StreamWatcher,
Serializable {
    private static final long serialVersionUID = 6311983374515379831L;
    private static final Logger logger = Logger.getLogger(DirectMulticastStreamWatcher.class);
    private transient Thread waitThread;
    private static int SOCKET_RECEIVE_TIMEOUT = 500;
    private static int BUF_LENGHT_MIN = 300;
    private static int WAIT_SPAN = 500;
    private boolean isReceivingData = false;
    private transient Runnable waiter = new Runnable(){

        public void run() {
            try {
                Thread.sleep(WAIT_SPAN);
                DirectMulticastStreamWatcher.this.isReceivingData = false;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    };

    public boolean isPlayed(Program program) {
        if (program.getIp() == null) {
            return false;
        }
        boolean isPlayed = false;
        logger.debug((Object)("Joining the multicast group " + program.getIp()));
        try {
            MulticastSocket s = new MulticastSocket(1234);
            s.setSoTimeout(SOCKET_RECEIVE_TIMEOUT);
            s.joinGroup(program.getIp());
            byte[] buf = new byte[1024];
            DatagramPacket recv = new DatagramPacket(buf, buf.length);
            try {
                this.isReceivingData = true;
                this.startWaitingForTheSocket();
                long bufLenght = 0L;
                while (this.isReceivingData) {
                    s.receive(recv);
                    if ((bufLenght += (long)recv.getLength()) < (long)BUF_LENGHT_MIN) continue;
                    this.isReceivingData = false;
                    this.waitThread.interrupt();
                }
                if (bufLenght >= (long)BUF_LENGHT_MIN) {
                    logger.log((Priority)Level.DEBUG, (Object)("Some data has been received : " + bufLenght + " bytes."));
                    isPlayed = true;
                } else {
                    logger.log((Priority)Level.DEBUG, (Object)("Not enough data received (" + bufLenght + " bytes) verifying the program " + program.getSapName()));
                }
            }
            catch (InterruptedIOException e) {
                logger.log((Priority)Level.DEBUG, (Object)("Socket TimeOut verifying the channel " + program.getSapName() + "."));
            }
            s.leaveGroup(program.getIp());
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        return isPlayed;
    }

    private synchronized void startWaitingForTheSocket() {
        this.waitThread = new Thread(this.waiter);
        this.waitThread.setName("waitThread");
        this.waitThread.start();
    }
}

