/*
 * Copyright (C) 2006-2008 the VideoLAN team
 *
 * This file is part of VLMa.
 *
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.model;

/**
 * An order that can be sent to a server.
 *
 * @author Adrien Grand <jpountz at videolan.org>
 * @author Sylvain Cadilhac <sylv at videolan.org>
 */
public class Order {

    private Adapter adapter;

    private MediaGroup medias;

    /**
     * Constructs a new Order.
     *
     * @param adapter the adapter to send commands to
     * @param medias the mediagroup that will be streamed when the order will
     *               be sent
     */
    public Order(Adapter adapter, MediaGroup medias) {
        this.adapter = adapter;
        this.medias = medias;
    }

    /**
     * Constructs a new Order with an empty {@link MediaGroup }.
     *
     * @param adapter the adapter to send commands to
     */
    public Order(Adapter adapter) {
        this(adapter, new MediaGroup());
    }

    /**
     * Gets the adapter associated with the order.
     *
     * @return the adapter
     */
    public Adapter getAdapter() {
        return adapter;
    }

    /**
     * Sets the adapter associated with the order.
     *
     * @param adapter the adapter to set
     */
    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    /**
     * Gets the media group to stream.
     *
     * @return the medias
     */
    public MediaGroup getMedias() {
        return medias;
    }

    /**
     * Sets the media group to stream.
     *
     * @param medias the medias to set
     */
    public void setMedias(MediaGroup medias) {
        this.medias = medias;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) return false;
        if (o instanceof Order) {
            Order other = (Order) o;
            return (adapter.equals(other.getAdapter()) && medias.equals(other.getMedias()));
        }
        return false;
    }

    @Override
    public int hashCode() {
        return adapter.hashCode() + medias.hashCode();
    }
}
